<?php
declare(strict_types=1);

/**
 * Eğer URL /{slug}/... ise ve companies.slug varsa tenant döner.
 * Public rotalar (/, /login, /register, /about vs) tenant sayılmaz.
 */
function tenant_resolve(PDO $pdo, string $path): ?array {
  $public = ['/', '/login', '/register', '/about', '/pricing'];
  if (in_array($path, $public, true)) return null;

  $parts = array_values(array_filter(explode('/', $path)));
  $slug = $parts[0] ?? '';
  if ($slug === '' || $slug === 'assets') return null;

  $st = $pdo->prepare("SELECT * FROM companies WHERE slug=? LIMIT 1");
  $st->execute([$slug]);
  $c = $st->fetch();
  return $c ?: null;
}

function tenant_slug(): string {
  return (string)($GLOBALS['tenant']['slug'] ?? '');
}

function tenant_strip_prefix(string $path): string {
  $tenant = $GLOBALS['tenant'];
  if (!$tenant) return $path;
  $prefix = '/' . $tenant['slug'];
  if ($path === $prefix) return '/';
  if (str_starts_with($path, $prefix . '/')) return substr($path, strlen($prefix));
  return $path;
}
